(function(exports) {
	var response_lenght = 5;
	var queryTimeout = 1000;

	var access_commands = [
		{"name": l100n.localize_string("access_control_on"), "command": "0x10000"},
		{"name": l100n.localize_string("access_control_off"), "command": "0x20000"},
		{"name": l100n.localize_string("access_level_reset"), "command": "0x30000"},
		{"name": l100n.localize_string("change_password"), "command": "0x40000"},
		//{"name": l100n.localize_string("counter_reset"), "command": "1991"},
		{"name": l100n.localize_string("download_settings"), "command": "0x00050000"},
		{"name": l100n.localize_string("upload_settings"), "command": "0x00060000"},
		{"name": l100n.localize_string("reboot"), "command": "0x746f6f62"}
	];
	var board_types = [
		{"name": "А - 230 V AC", "command": "1"},
		{"name": "D - 24 V DC", "command": "2"}
	];
	var restart_reason = [
		{"new_value": "Button \"Reset\"", "raw_value": "1"},
		{"new_value": "WatchDog", "raw_value": "9"},
		{"new_value": "PowerUp", "raw_value": "67"},
		{"new_value": "Software", "raw_value": "5"}
	];
	var module_types = [
		{"name": l100n.localize_string("dummy"), "command": "0"},
		{"name": "1 - 10HDI", "command": "1"},
		{"name": "2 - 10DI", "command": "2"},
		{"name": "3 - 8AI", "command": "3"},
		{"name": "4 - 8CTI", "command": "4"},
		{"name": "MCU - 5 - 4RTD (400Ω)", "command": "5"},
      	{"name": "MCU - 5 - 4RTD (10kΩ)", "command": "19"},
		{"name": "7 - 2AO", "command": "7"},
		{"name": "8 - 4RO", "command": "8"},
		{"name": "9 - 10HDO", "command": "9"},
		{"name": "10 - MDR-I/O-1", "command": "10"},
		{"name": "MCU - 13 - F LCD", "command": "13"},
		{"name": "MCU - 14 - F IO", "command": "14"},
		{"name": "H - EM", "command": "16"},
		{"name": "L - EM", "command": "17"},
		{"name": "18 - MDR-I/O-3", "command": "18"},
		{"name": l100n.localize_string("slot_absent"), "command": "255"}
	];
	var connection_scheme = [
		{"name": "4LN3", "command": "0"},
		{"name": "4LL3/3LL3", "command": "8"},
		{"name": "4LN2", "command": "1"},
		{"name": "3LN3", "command": "4"},
		{"name": "3LN2", "command": "5"},
		{"name": "3LL2", "command": "9"},
		{"name": "3OP3", "command": "2"},
		{"name": "3OP2", "command": "3"}
	];
	var current_range = [
		{"name": l100n.localize_string("H-5A/L-0,1A"), "command": "1"},
		{"name": l100n.localize_string("H-1,25A/L-0,025A"), "command": "4"}
	];
	var access_values = [
		{"new_value": l100n.localize_string("off"), "raw_value": "0"},
		{"new_value": l100n.localize_string("user"), "raw_value": "1"},
		{"new_value": l100n.localize_string("admin"), "raw_value": "2"}
	];
	var default_checkbox_values = [
		{"new_value": l100n.localize_string("off"), "raw_value": "0"},
		{"new_value": l100n.localize_string("on"), "raw_value": "1"}
	];
	var on_off_values = [
			{"name": l100n.localize_string("off"), "command": "0"},
			{"name": l100n.localize_string("on"), "command": "1"}
	];
	var baudrate = [
		{"name": l100n.localize_string("9.6"), "command": "9600"},
		{"name": l100n.localize_string("19.2"), "command": "19200"},
		{"name": l100n.localize_string("38.4"), "command": "38400"},
		{"name": l100n.localize_string("57.6"), "command": "57600"},
		{"name": l100n.localize_string("115.2"), "command": "115200"}
	];
	var CAN_speed = [
		{"name": "50", "command": "50000"},
		{"name": "100", "command": "100000"},
		{"name": "125", "command": "125000"},
		{"name": "250", "command": "250000"},
		{"name": "500", "command": "500000"},
		{"name": "800", "command": "800000"},
		{"name": "1000", "command": "1000000"}
	];
    var CAN_port_status = [
		{"new_value": "No error", "raw_value": "0"},
		{"new_value": "Protocol Warning (1)", "raw_value": "1"},
		{"new_value": "Protocol Warning. Passive (3)", "raw_value": "3"},
		{"new_value": "Form error (19)", "raw_value": "19"},
    	{"new_value": "Form error. Bus-off. Passive. Protocol Warning (23)", "raw_value": "23"},
		{"new_value": "Acknowledgment (35)", "raw_value": "35"},
		{"new_value": "Bit recessive (64)", "raw_value": "64"},
    	{"new_value": "Bit recessive. Passive. Protocol Warning (67)", "raw_value": "67"},
		{"new_value": "Bit dominant (128)", "raw_value": "128"},
		{"new_value": "Bit dominant. Protocol Warning (129)", "raw_value": "129"},
		{"new_value": "Bit dominant. Protocol Warning. Passive (131)", "raw_value": "131"},
		{"new_value": "Bus-off. Bit dominant. Protocol Warning (133)", "raw_value": "133"},
		{"new_value": "Bus-off. Bit dominant. Passive. Protocol Warning (135)", "raw_value": "135"},
	];
	var canopen_node_status = [
		{"new_value": "No Active", "raw_value": "0"},
		{"new_value": "Active", "raw_value": "1"},
	];
	var canopen_NMT_status = [
		{"new_value": "Initialisation", "raw_value": "0"},
		{"new_value": "Disconnected", "raw_value": "1"},
		{"new_value": "Connecting", "raw_value": "2"},
//		{"new_value": "Preparing", "raw_value": "2"},
		{"new_value": "Stopped", "raw_value": "4"},
		{"new_value": "Operational", "raw_value": "5"},
		{"new_value": "Pre operational", "raw_value": "127"},
		{"new_value": "Not configured", "raw_value": "15"},
	];
	var sensor_type = [
		{"name": "М - 50", "command": "1"},
		{"name": "Pt - 50", "command": "2"},
		{"name": "Pt - 100", "command": "3"},
		{"name": "П - 50", "command": "4"},
		{"name": "П - 100", "command": "5"}
	];
	var parity = [
		{"name": l100n.localize_string("off"), "command": "0"},
		{"name": l100n.localize_string("even"), "command": "1"},
		{"name": l100n.localize_string("odd"), "command": "2"}
	];
	var stopbits = [
		{"name": "1", "command": "1"},
		{"name": "2", "command": "2"}
	];
	var report_flag= [
        {"name": l100n.localize_string("REPORT_FLAG_OK"), "command": "0x80000000"},
		{"name": l100n.localize_string("REPORT_FLAG_NOT_FULL"), "command": "0x40000000"},
		{"name": l100n.localize_string("REPORT_FLAG_ENERGY_CLEANED"), "command": "0x20000000"},
		{"name": l100n.localize_string("REPORT_FLAG_TIME_SHIFT_FORWARD"), "command": "0x10000000"},
		{"name": l100n.localize_string("REPORT_FLAG_TIME_SHIFT_BACKWARD"), "command": "0x08000000"},
		{"name": l100n.localize_string("REPORT_FLAG_TIME_CHANGED"), "command": "0x04000000"},
		{"name": l100n.localize_string("REPORT_FLAG_PREVIUOS_REPORT"), "command": "0x02000000"},
	];
    var appsw_status = [
        {"new_value": "Running", "raw_value": "1"},
        {"new_value": "Stopped", "raw_value": "2"},
        {"new_value": "Stopped with an Error", "raw_value": "16"},
        {"new_value": "No program", "raw_value": "255"}
    ];
    var appsw_cmd = [
        {"name": "Run", "command": "1"},
        {"name": "Stop", "command": "2"},
    ];
	var hw_error_flags = [
		{"new_value": l100n.localize_string("NO_ERROR"), "raw_value": "0"},
        {"new_value": l100n.localize_string("HW_ERROR_NO_MAINS_POWER"), "raw_value": "1"},
		{"new_value": l100n.localize_string("HW_ERROR_FLASH"), "raw_value": "2"},
		{"new_value": l100n.localize_string("HW_ERROR_CRITICAL_STORAGE"), "raw_value": "4"},
		{"new_value": l100n.localize_string("HW_ERROR_EXT_RAM"), "raw_value": "8"},
		{"new_value": l100n.localize_string("HW_ERROR_UNSPECIFIED"), "raw_value": "16"},
		{"new_value": l100n.localize_string("HW_ERROR_BATTERY"), "raw_value": "32"},
		{"new_value": l100n.localize_string("HW_ERROR_RTC"), "raw_value": "64"},
		{"new_value": l100n.localize_string("HW_ERROR_COMM"), "raw_value": "128"},
		{"new_value": l100n.localize_string("HW_ERROR_MODULE_1"), "raw_value": "256"},
		{"new_value": l100n.localize_string("HW_ERROR_MODULE_2"), "raw_value": "512"},
		{"new_value": l100n.localize_string("HW_ERROR_MODULE_3"), "raw_value": "1024"},
		{"new_value": l100n.localize_string("HW_ERROR_MODULE_4"), "raw_value": "2048"},
		{"new_value": l100n.localize_string("HW_ERROR_MODULE_5"), "raw_value": "4096"},
		{"new_value": l100n.localize_string("HW_ERROR_MODULE_6"), "raw_value": "8192"},
		{"new_value": l100n.localize_string("HW_ERROR_MODULE_7"), "raw_value": "16384"},
		{"new_value": l100n.localize_string("HW_ERROR_MODULE_8"), "raw_value": "32768"},
    ];
	var sw_error_flags = [
		{"new_value": l100n.localize_string("NO_ERROR"), "raw_value": "0"},
        {"new_value": l100n.localize_string("SW_ERROR_NEED_RESTART"), "raw_value": "1"},
		{"new_value": l100n.localize_string("SW_ERROR_FS"), "raw_value": "2"},
		{"new_value": l100n.localize_string("SW_ERROR_RAM"), "raw_value": "4"},
		{"new_value": l100n.localize_string("SW_ERROR_RESCUE_FROM_FAILURE"), "raw_value": "8"},
		{"new_value": l100n.localize_string("SW_ERROR_EXCEPTION"), "raw_value": "16"},
		{"new_value": l100n.localize_string("SW_ERROR_INCOMTATIBLE_SETTINGS"), "raw_value": "32"},
		{"new_value": l100n.localize_string("SW_ERROR_TIME"), "raw_value": "64"},
		{"new_value": l100n.localize_string("SW_ERROR_APPLICATION"), "raw_value": "128"},
    ];
	// Modbus client
    var mb_functions = [
        {"name": "Not selected", "command": "0"},
	    {"name": "3 - Read Holding Registers",    "command": "3"},
	    {"name": "4 - Read Input Registers",      "command": "4"},
	    {"name": "6 - Write Single Register",     "command": "6"},
	    {"name": "16 - Write Multiple Registers", "command": "16"}
    ];
    var byte_and_word_order = [
	    {"new_value": "Do not change", "raw_value": "0"},
		//{"name":"Do not change","command":"0"},
		//{"name":"Byte Swap","command":"1"}
    ];
    var req_trigger_type = [
	    {"name": "Not selected", "command": "0"},
	    {"name": "Polling", "command": "1"},
	    {"name": "Rising Edge", "command": "2"},
	    {"name": "Polling and Rising Edge", "command": "3"},
    ];
    var request_status = [
	    {"new_value": "Not enabled", "raw_value":               "0"},
	    {"new_value": "Misconfiguration", "raw_value":          "40960"},
        {"new_value": "Active and Enabled", "raw_value":        "49152"},
    ];
    var data_status = [
	    {"new_value": "Good Data", "raw_value": "0"},
        {"new_value": "Bad data", "raw_value": "32768"},
        {"new_value": "Bad data. Data Overriden", "raw_value": "32832"},
        {"new_value": "Bad data. Timeout", "raw_value": "32784"},
        {"new_value": "Bad data. Timeout. Data Overriden", "raw_value": "32848"},
        {"new_value": "Bad data. Frame Error", "raw_value": "32800"},
        {"new_value": "Bad data. Frame Error. Data Overriden", "raw_value": "32864"},
    ];

	var data_type_template = {"templates": [
		{"index": "1011_1","template": "restore_params"},
		{"index": "1027_1","template": "combobox", "commands": board_types},
		{"index": "1027_2","template": "combobox", "commands": module_types},
		{"index": "1027_3","template": "combobox", "commands": module_types},
		{"index": "1027_4","template": "combobox", "commands": module_types},
		{"index": "1027_5","template": "combobox", "commands": module_types},
		{"index": "1027_6","template": "combobox", "commands": module_types},
		{"index": "1027_7","template": "combobox", "commands": module_types},
		{"index": "1027_8","template": "combobox", "commands": module_types},
		{"index": "1027_9","template": "combobox", "commands": module_types},
		{"index": "2000_2","template": "ip_addr"},
		{"index": "2000_3","template": "ip_addr"},
		{"index": "2000_6","template": "ip_addr"},
		{"index": "2001_1","template": "change_value", "commands": restart_reason},
		{"index": "2001_12","template": "change_value", "commands": hw_error_flags},
		{"index": "2001_13","template": "change_value", "commands": sw_error_flags},
		{"index": "2002_1","template": "combobox", "commands": access_commands},
		{"index": "2001_9","template": "change_value", "commands": access_values},
		{"index": "2002_2","template": "password"},
		{"index": "2081_1","template": "datetime"},
		{"index": "2101_5", "template": "change_value", "commands":CAN_port_status},
		{"index": "2105_5", "template": "change_value", "commands":CAN_port_status},
		{"index": "2109_5", "template": "change_value", "commands":CAN_port_status},
		{"index": "2213_2","template": "ip_addr"},
		{"index": "2213_3","template": "ip_addr"},
		{"index": "2213_4","template": "ip_addr"},
		{"index": "2213_5","template": "ip_addr"},
		{"index": "2213_6","template": "ip_addr"},
		{"index": "2213_1","template": "combobox", "commands": on_off_values},
		{"index": "2301_1","template": "change_value", "commands": canopen_node_status},
		{"index": "2301_2","template": "change_value", "commands": canopen_node_status},
		{"index": "2301_3","template": "change_value", "commands": canopen_node_status},
		{"index": "2301_4","template": "change_value", "commands": canopen_node_status},
		{"index": "2301_5","template": "change_value", "commands": canopen_node_status},
		{"index": "2301_6","template": "change_value", "commands": canopen_node_status},
		{"index": "2301_7","template": "change_value", "commands": canopen_node_status},
		{"index": "2301_8","template": "change_value", "commands": canopen_node_status},
		{"index": "2343_1","template": "boolean_type"},
		{"index": "3000_5","template": "change_value", "commands": report_flag},
		{"index": "3001_1","template": "boolean_type"},
		{"index": "3001_3","template": "date"},
		{"index": "5000_2","template": "datetime_simple"},
		{"index": "5000_3","template": "ip_addr"},
		{"index": "5001_1","template": "change_value", "commands": appsw_status},
		{"index": "5002_1","template": "combobox", "commands": appsw_cmd},
	]};
// 1003 Error field
	for (var err_field = 1; err_field < 65; err_field++) {
        data_type_template.templates.push({"index": `1003_${err_field}`,"template": "error_field"})
    }
// 1016 Heartbeat Consumer
	for (var subi = 1; subi < 65; subi++) {
        data_type_template.templates.push({"index": `1016_${subi}`,"template": "consumer_heartbeat"})
    }

// RPDO Mapping
	for (var index = 0x1600; index <= 0x163F; index++) {
		for (var subi = 1; subi < 12; subi++) {
			data_type_template.templates.push({"index": `${index.toString(16).toUpperCase()}_${subi}`,"template": "pdo_mapping"})
		}
	}
// TPDO Mapping
	for (var index = 0x1A00; index <= 0x1A7F; index++) {
		for (var subi = 1; subi < 12; subi++) {
			data_type_template.templates.push({"index": `${index.toString(16).toUpperCase()}_${subi}`,"template": "pdo_mapping"})
		}
	}
// Communication (CAN, Serial and Ethernet)
	for (var interface_number = 0; interface_number < 3; interface_number++){
		var eds_index = 0x2143 + interface_number*4
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_1`,"template": "boolean_type"})
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_2`,"template": "combobox", "commands": baudrate})
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_4`,"template": "combobox", "commands": parity})
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_5`,"template": "combobox", "commands": stopbits})
		var eds_index = 0x2103 + interface_number*4
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_1`,"template": "boolean_type"})
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_2`,"template": "combobox", "commands": CAN_speed})
		var eds_index = 0x2333 + interface_number*4
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_1`,"template": "boolean_type"})
		var eds_index = 0x2383 + interface_number*4
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_1`,"template": "boolean_type"})
		var eds_index = 0x2323 + interface_number*4
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_1`,"template": "boolean_type"})
	}
	for (var interface_number = 0; interface_number < 3; interface_number++) {
		for (var subi = 1; subi < 64; subi++) {
		    var index = 0x2311 + interface_number*4
    		data_type_template.templates.push({"index": `${index.toString(16).toUpperCase()}_${subi}`,"template": "change_value", "commands": canopen_NMT_status})
        }
    }
// Modules (boards)
	for (var board_number = 1; board_number < 9; board_number++) {
		var eds_index = 0x3F03 + board_number*0x100
		var template = {"index": `${eds_index.toString(16).toUpperCase()}_1`,"template": "restore_params"}
		data_type_template.templates.push(template)
		for (var eds_subindex = 1; eds_subindex < 9; eds_subindex++) {
			var eds_index = 0x3F39 + board_number*0x100
			var template = {"index": `${eds_index.toString(16).toUpperCase()}_${eds_subindex}`,"template": "combobox", "commands": sensor_type}
			data_type_template.templates.push(template)
		}
	}
// PM Modules
	for (var board_number = 0; board_number < 8; board_number++) {
		var eds_index = 0x4060 + board_number*0x100
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_1`,"template": "combobox", "commands": connection_scheme})
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_2`,"template": "combobox", "commands": current_range})
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_3`,"template": "combobox", "commands": current_range})
    }
// Energy Profiles
	data_type_template.templates.push({"index": "3000_2","template": "datetime_simple"})
	data_type_template.templates.push({"index": "3000_3","template": "datetime_simple"})
	data_type_template.templates.push({"index": "3000_4","template": "datetime_simple"})
//	data_type_template.templates.push({"index": "3001_3","template": "date"})
	for (var board_number = 0; board_number < 8; board_number++) {
      	for (var pm_profile = 0; pm_profile < (160 + 1); pm_profile++) {
            var index = 0x3002 + (board_number * 0x100) + pm_profile
            data_type_template.templates.push({"index": `${index.toString(16).toUpperCase()}_1`,"template": "datetime_simple"})
		    data_type_template.templates.push({"index": `${index.toString(16).toUpperCase()}_2`,"template": "datetime_simple"})
		    data_type_template.templates.push({"index": `${index.toString(16).toUpperCase()}_3`,"template": "hex"})
        }
    }

    const serial_port_number = 3
    const serial_port_requests = 128
    const ports_req_offset = 0x300
    const tcp_port_requests = 256
//RTU Client
	for (var serial_port_i = 0; serial_port_i < serial_port_number; serial_port_i++){
        var port_index = 0x5100 + (ports_req_offset * serial_port_i)
	    for (var request_per_port = 0; request_per_port < serial_port_requests; request_per_port++){
		    var eds_index = port_index + request_per_port*2 // Serial 1
		    data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_3`, "template": "change_value",  "commands": request_status})
		    data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_11`, "template": "combobox",     "commands": mb_functions})
		    data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_14`, "template": "combobox",     "commands": req_trigger_type})
		    data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_16`, "template": "change_value", "commands": byte_and_word_order})
            eds_index += 1
		    data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_2`, "template": "change_value", "commands": data_status})
        }
    }
//TCP Client
	for (var request_per_port = 0; request_per_port < tcp_port_requests; request_per_port++){
		var eds_index = 0x5A00 + request_per_port*2
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_3`, "template": "change_value", "commands": request_status})
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_10`,"template": "ip_addr"})
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_15`, "template": "combobox", "commands": mb_functions})
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_18`, "template": "combobox", "commands": req_trigger_type})
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_20`, "template": "change_value", "commands": byte_and_word_order})
        eds_index += 1
		data_type_template.templates.push({"index": `${eds_index.toString(16).toUpperCase()}_2`, "template": "change_value", "commands": data_status})
    }

	var expert_page_dictionary = [
		{"minIndex" : "0x0001", "maxIndex" : "0x0FFF", "name" : "Data Type Definitions"},
		{"minIndex" : "0x1000", "maxIndex" : "0x1029", "name" : "Communication Parameters"},
		{"minIndex" : "0x1200", "maxIndex" : "0x12FF", "name" : "SDO Parameters"},
		{"minIndex" : "0x1400", "maxIndex" : "0x15FF", "name" : "Receive PDO Parameters"},
		{"minIndex" : "0x1600", "maxIndex" : "0x17FF", "name" : "Receive PDO Mapping"},
		{"minIndex" : "0x1800", "maxIndex" : "0x19FF", "name" : "Transmit PDO Parameters"},
		{"minIndex" : "0x1A00", "maxIndex" : "0x1BFF", "name" : "Transmit PDO Mapping"},
		{"minIndex" : "0x1C00", "maxIndex" : "0x1FFF", "name" : "Other Communication Parameters"},
		//{"minIndex" : "0x2000", "maxIndex" : "0x4FFF", "name" : "Manufacturer Specific"},
		{"minIndex" : "0x2000", "maxIndex" : "0x2FFF", "name" : "General Device Parameters"},
		{"minIndex" : "0x3F00", "maxIndex" : "0x3FFF", "name" : "Module 0"},
		{"minIndex" : "0x4000", "maxIndex" : "0x40FF", "name" : "Module 1"},
		{"minIndex" : "0x4100", "maxIndex" : "0x41FF", "name" : "Module 2"},
		{"minIndex" : "0x4200", "maxIndex" : "0x42FF", "name" : "Module 3"},
		{"minIndex" : "0x4300", "maxIndex" : "0x43FF", "name" : "Module 4"},
		{"minIndex" : "0x4400", "maxIndex" : "0x44FF", "name" : "Module 5"},
		{"minIndex" : "0x4500", "maxIndex" : "0x45FF", "name" : "Module 6"},
		{"minIndex" : "0x4600", "maxIndex" : "0x46FF", "name" : "Module 7"},
		{"minIndex" : "0x4700", "maxIndex" : "0x47FF", "name" : "Module 8"},
		{"minIndex" : "0x4C00", "maxIndex" : "0x4FFF", "name" : "External IO"},
		{"minIndex" : "0x3000", "maxIndex" : "0x3EFF", "name" : "Energy Profiles"},
		{"minIndex" : "0x5100", "maxIndex" : "0x53FF", "name" : "Modbus Serial 1 Client Requests"},
		{"minIndex" : "0x5400", "maxIndex" : "0x56FF", "name" : "Modbus Serial 2 Client Requests"},
		{"minIndex" : "0x5700", "maxIndex" : "0x59FF", "name" : "Modbus Serial 3 Client Requests"},
		{"minIndex" : "0x5A00", "maxIndex" : "0x5FFF", "name" : "Modbus TCP Client Requests"},
		{"minIndex" : "0x6000", "maxIndex" : "0x9FFF", "name" : "Standardized Device Profile"},
		{"minIndex" : "0x5000", "maxIndex" : "0x500F", "name" : "Application SW Parameters"},
		{"minIndex" : "0xA000", "maxIndex" : "0xAFFF", "name" : "Application SW Variables"},
		{"minIndex" : "0xB000", "maxIndex" : "0xBFFF", "name" : "Application SW Profiles"}
	]

	exports.expert_page_dictionary = function() { return expert_page_dictionary;}
	exports.response_lenght = function() { return response_lenght;}
	exports.queryTimeout = function() { return queryTimeout;}
	exports.data_type_template = function() { return data_type_template;}
	exports.default_checkbox_values = function() { return default_checkbox_values;}
})(this.configuration_expert = {});
